package com.example.bytesbee.alphabets.activities;

import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.example.bytesbee.alphabets.activities.constants.StaticNames;
import com.example.bytesbee.alphabets.activities.R;
import com.example.bytesbee.alphabets.activities.constants.IConstants;
import com.example.bytesbee.alphabets.activities.utils.Screens;
import com.example.bytesbee.alphabets.activities.utils.Utils;
import com.google.android.material.snackbar.Snackbar;

/**
 * @author Prashant
 * @company BytesBee
 * @link http://bytesbee.com/
 */
public class MainActivity extends BaseActivity implements OnClickListener, IConstants {

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        final ImageView btnAbc = findViewById(R.id.btnAbc);
        final ImageView btnNumbers = findViewById(R.id.btnNumbers);
        final ImageView btnShapes = findViewById(R.id.btnShape);
        final ImageView btnColor = findViewById(R.id.btnColor);
        final ImageView btnMOY = findViewById(R.id.btnMOY);
        final ImageView btnDOW = findViewById(R.id.btnDOW);
        final ImageView btnFruits = findViewById(R.id.btnFruits);
        final ImageView btnVegetables = findViewById(R.id.btnVegetables);
        final ImageView btnSetting = findViewById(R.id.btnSetting);

        btnAbc.setOnClickListener(this);
        btnNumbers.setOnClickListener(this);
        btnShapes.setOnClickListener(this);
        btnColor.setOnClickListener(this);
        btnMOY.setOnClickListener(this);
        btnDOW.setOnClickListener(this);
        btnFruits.setOnClickListener(this);
        btnVegetables.setOnClickListener(this);
        btnSetting.setOnClickListener(this);

        Utils.loadBannerAd(mActivity);
        Utils.firstLoadAds(mActivity);
    }

    @Override
    public void onClick(final View v) {
        final int id = v.getId();
        if (id == R.id.btnAbc) {
            Utils.showIntAds(mActivity, AlphabetActivity.class);
        } else if (id == R.id.btnNumbers) {
            Utils.showIntAds(mActivity, NumberActivity.class);
        } else if (id == R.id.btnShape) {
            Utils.showIntAds(mActivity, null, SHAPES, activityHandler);
        } else if (id == R.id.btnColor) {
            Utils.showIntAds(mActivity, null, COLORS, activityHandler);
        } else if (id == R.id.btnMOY) {
            Utils.showIntAds(mActivity, null, MOY, activityHandler);
        } else if (id == R.id.btnDOW) {
            Utils.showIntAds(mActivity, null, DOW, activityHandler);
        } else if (id == R.id.btnFruits) {
            Utils.showIntAds(mActivity, null, FRUITS, activityHandler);
        } else if (id == R.id.btnVegetables) {
            Utils.showIntAds(mActivity, null, VEGETABLES, activityHandler);
        } else if (id == R.id.btnSetting) {
            Utils.showIntAds(mActivity, SettingsActivity.class);
        }
    }

    private final Handler activityHandler = new Handler(message -> {
        switch (message.what) {
            case COLORS:
                Screens.openCommonActivity(mActivity, StaticNames.COLOR_IMAGES, StaticNames.COLOR_SOUND);
                break;
            case SHAPES:
                Screens.openCommonActivity(mActivity, StaticNames.SHAPES_IMAGES, StaticNames.SHAPES_SOUND);
                break;
            case MOY:
                Screens.openCommonActivity(mActivity, StaticNames.MOY_IMAGES, StaticNames.MOY_SOUND);
                break;
            case DOW:
                Screens.openCommonActivity(mActivity, StaticNames.DOW_IMAGES, StaticNames.DOW_SOUND);
                break;
            case FRUITS:
                Screens.openCommonActivity(mActivity, StaticNames.FRUITS_IMAGES, StaticNames.FRUITS_SOUNDS);
                break;
            case VEGETABLES:
                Screens.openCommonActivity(mActivity, StaticNames.VEGETABLES_IMAGES, StaticNames.VEGETABLES_SOUNDS);
                break;
        }
        return true;
    });

    @Override
    protected void onStop() {
        super.onStop();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    private boolean doubleBackToExitPressedOnce = false;

    @Override
    public void onBackPressed() {
        if (doubleBackToExitPressedOnce) {
            finish();
            return;
        }

        this.doubleBackToExitPressedOnce = true;

        try {
            Snackbar snackbar = Snackbar.make(findViewById(android.R.id.content), R.string.press_again_to_exit, Snackbar.LENGTH_LONG);
            View sbView = snackbar.getView();
            TextView textView = sbView.findViewById(R.id.snackbar_text);
            textView.setTypeface(Utils.getCustomFont(mActivity));
            textView.setTextColor(Color.YELLOW);
            snackbar.show();
        } catch (Exception e) {
            Utils.getErrors(e);
            Toast.makeText(this, R.string.press_again_to_exit, Toast.LENGTH_SHORT).show();
        }

        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                doubleBackToExitPressedOnce = false;
            }
        }, EXIT_DELAY);
    }

}
